function [y] = dertriangle(x,xi)
%
% function [y] = triangle(x,h,xi)
%
% Devuelve la funcion lineal continua a trozos lineales tipica de los 
% elementos finitos en una dimension
%
% ENTRADA
%
%   x   valor de la variable independiente en el que se desea el valor de
%       la funcion
%   xi  array de tres valores con los nodos izquierdo, central y derecho
%
% SALIDA
%   y   valor de la funcion en el punto x
%
%
%               h
%                /\
%               /  \
%              /    \
%             /      \
%            /        \
%           /          \
%  ________/            \_________
%       xi(1)  xi(2)  xi(3)
%
h = 1.0;
p1 = h/(xi(2)-xi(1));
p2 = h/(xi(3)-xi(2));

y = zeros(size(x));

l1 = x > xi(1) & x <= xi(2);
l2 = x > xi(2) & x < xi(3);
y( l1 ) =   p1;
y( l2 ) = - p2;
    